/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public class TagPredicate
implements Predicate<class_2487> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final TagPredicate ANY = new TagPredicate(null);
    @Nullable
    private final class_2487 tag;

    @Override
    public boolean test(@Nullable class_2487 toTest) {
        return class_2512.method_10687((class_2520)this.tag, (class_2520)toTest, (boolean)true);
    }

    public JsonElement serialize() {
        if (this.tag == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.tag.toString());
    }

    public void write(class_2540 buffer) {
        if (this.tag != null) {
            buffer.writeBoolean(true);
            buffer.method_10794(this.tag);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static TagPredicate deserialize(JsonElement element) {
        if (!element.isJsonNull()) {
            try {
                class_2487 nbt = element.isJsonObject() ? class_2522.method_10718((String)GSON.toJson(element)) : class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"predicate"));
                return new TagPredicate(nbt);
            }
            catch (CommandSyntaxException ex) {
                throw new JsonSyntaxException("Invalid nbt tag: ", (Throwable)ex);
            }
        }
        return ANY;
    }

    public static TagPredicate read(class_2540 buffer) {
        class_2487 tag = null;
        if (buffer.readBoolean()) {
            tag = buffer.method_10798();
        }
        return new TagPredicate(tag);
    }

    public TagPredicate(@Nullable class_2487 tag) {
        this.tag = tag;
    }
}

